const loki = require('lokijs');

// Initialize database
const db = new loki('users.db');

db.loadDatabase({}, function() {
    console.log('Database loaded');
    
    // Get collections
    const categoriesCollection = db.getCollection('categories');
    const subcategoriesCollection = db.getCollection('subcategories');
    
    if (!categoriesCollection || !subcategoriesCollection) {
        console.log('Collections not found');
        return;
    }
    
    // Check newly added categories and their subcategories
    const newlyPopulatedCategories = ['Electronics', 'Fashion', 'Home & Garden', 'Sports'];
    
    console.log('=== NEWLY ADDED SUBCATEGORIES ===\n');
    
    newlyPopulatedCategories.forEach(categoryName => {
        const category = categoriesCollection.findOne({ name: categoryName });
        if (category) {
            console.log(`📂 ${categoryName} (ID: ${category.$loki})`);
            const subcategories = subcategoriesCollection.find({ categoryId: category.$loki });
            subcategories.forEach((subcat, index) => {
                console.log(`  ${index + 1}. ${subcat.name} (${subcat.slug})`);
                console.log(`     Description: ${subcat.description}`);
            });
            console.log(`   Total: ${subcategories.length} subcategories\n`);
        }
    });
    
    // Overall summary
    const totalCategories = categoriesCollection.count();
    const totalSubcategories = subcategoriesCollection.count();
    
    console.log('=== FINAL SUMMARY ===');
    console.log(`✅ Total Categories: ${totalCategories}`);
    console.log(`✅ Total Subcategories: ${totalSubcategories}`);
    console.log(`✅ All categories now have subcategories!`);
    
    // Check if any category is still without subcategories
    const categories = categoriesCollection.find({});
    const categoriesWithoutSubcategories = categories.filter(cat => {
        const subcatCount = subcategoriesCollection.count({ categoryId: cat.$loki });
        return subcatCount === 0;
    });
    
    if (categoriesWithoutSubcategories.length === 0) {
        console.log(`✅ SUCCESS: All ${totalCategories} categories have subcategories!`);
    } else {
        console.log(`⚠️  ${categoriesWithoutSubcategories.length} categories still without subcategories`);
    }
});