const loki = require('lokijs');

// Initialize database
const db = new loki('users.db');

db.loadDatabase({}, function() {
    console.log('🔍 Testing category filter data after fixes...\n');
    
    // Get collections
    const categoriesCollection = db.getCollection('categories');
    const subcategoriesCollection = db.getCollection('subcategories');
    
    // Get sample data
    const categories = categoriesCollection.find({}).slice(0, 3);
    const subcategories = subcategoriesCollection.find({}).slice(0, 10);
    
    console.log('📂 Sample categories:');
    categories.forEach(cat => {
        console.log(`  ${cat.name}: $loki=${cat.$loki}, id=${cat.id || 'undefined'}`);
    });
    
    console.log('\n📁 Sample subcategories:');
    subcategories.forEach(sub => {
        console.log(`  ${sub.name}: categoryId="${sub.categoryId}" (${typeof sub.categoryId})`);
    });
    
    // Test the filter logic with first category
    const testCategory = categories[0];
    const testCategoryIdAsString = testCategory.$loki.toString();
    
    console.log(`\n🧪 Testing filter with category "${testCategory.name}" (ID: ${testCategoryIdAsString})`);
    
    const matchingSubcategories = subcategoriesCollection.find({}).filter(sub => 
        sub.categoryId === testCategoryIdAsString
    );
    
    console.log(`Found ${matchingSubcategories.length} matching subcategories:`);
    matchingSubcategories.slice(0, 5).forEach(sub => {
        console.log(`  ✅ ${sub.name}`);
    });
    
    // Test what the API should return
    console.log('\n📡 Testing API structure:');
    const apiCategories = categories.map(category => ({
        ...category,
        id: category.$loki.toString()
    }));
    
    console.log('Categories with string IDs:');
    apiCategories.forEach(cat => {
        console.log(`  ${cat.name}: id="${cat.id}" (${typeof cat.id}), $loki=${cat.$loki}`);
    });
});