const Loki = require('lokijs');

console.log("🔍 Testing subcategories API logic...");

const db = new Loki("users.db", {
  autoload: true,
  autoloadCallback: function () {
    const subcategories = db.getCollection('subcategories');
    const categories = db.getCollection('categories');
    
    if (!subcategories || !categories) {
      console.log("❌ Collections not found.");
      process.exit(1);
    }

    console.log(`Found ${subcategories.data.length} subcategories and ${categories.data.length} categories`);

    // Test the same logic as the API
    const allSubcategories = subcategories.find({});
    
    console.log("\n🔍 Testing first 5 subcategories with parent lookup:");
    
    allSubcategories.slice(0, 5).forEach((subcategory, index) => {
      // Find parent category by matching $loki ID with categoryId
      const parentCategory = categories.findOne({ $loki: parseInt(subcategory.categoryId) });
      
      console.log(`${index + 1}. ${subcategory.name}`);
      console.log(`   CategoryID: ${subcategory.categoryId} (type: ${typeof subcategory.categoryId})`);
      console.log(`   Parent Found: ${parentCategory ? 'YES' : 'NO'}`);
      if (parentCategory) {
        console.log(`   Parent: ${parentCategory.icon} ${parentCategory.name} (LokiID: ${parentCategory.$loki})`);
      }
      console.log();
    });

    // Test enhanced subcategories
    const enhancedSubcategories = allSubcategories.slice(0, 3).map(subcategory => {
      const parentCategory = categories.findOne({ $loki: parseInt(subcategory.categoryId) });
      
      return {
        ...subcategory,
        parentCategory: parentCategory ? {
          id: parentCategory.$loki.toString(),
          name: parentCategory.name,
          icon: parentCategory.icon,
          slug: parentCategory.slug,
          isActive: parentCategory.isActive
        } : null
      };
    });

    console.log("📋 Enhanced subcategories sample:");
    enhancedSubcategories.forEach((sub, index) => {
      console.log(`${index + 1}. ${sub.name}`);
      console.log(`   Parent: ${sub.parentCategory ? `${sub.parentCategory.icon} ${sub.parentCategory.name}` : 'NULL'}`);
    });

    process.exit(0);
  },
});