const http = require('http');

async function testStatusUpdate() {
  console.log('Testing order status update...');
  
  // Test updating order ORD-20251020-0423 from pending to shipped
  const updateData = JSON.stringify({ orderStatus: 'shipped' });

  const options = {
    hostname: 'localhost',
    port: 3000,
    path: '/api/orders/ORD-20251020-0423',
    method: 'PATCH',
    headers: {
      'Content-Type': 'application/json',
      'Content-Length': Buffer.byteLength(updateData)
    }
  };

  return new Promise((resolve, reject) => {
    const req = http.request(options, (res) => {
      let data = '';
      res.on('data', (chunk) => { data += chunk; });
      res.on('end', () => {
        console.log('Response Status:', res.statusCode);
        console.log('Response:', data);
        resolve({ status: res.statusCode, data });
      });
    });

    req.on('error', (error) => {
      console.error('Error:', error.message);
      reject(error);
    });

    req.write(updateData);
    req.end();
  });
}

// Wait for server to be ready, then test
setTimeout(async () => {
  try {
    await testStatusUpdate();
    
    // Check database after update
    console.log('\n--- Checking database after update ---');
    const fs = require('fs');
    const data = JSON.parse(fs.readFileSync('users.db', 'utf8'));
    const orders = data.collections.find(c => c.name === 'orders');
    const updatedOrder = orders.data.find(order => order.orderNumber === 'ORD-20251020-0423');
    
    if (updatedOrder) {
      console.log('Updated Order Status:', updatedOrder.orderStatus);
      console.log('Last Updated:', updatedOrder.updatedAt);
    } else {
      console.log('Order not found in database');
    }
  } catch (error) {
    console.error('Test failed:', error.message);
  }
}, 3000);