// Test script to manually create an order
const https = require('http');

const testOrder = {
  "customerInfo": {
    "firstName": "John",
    "lastName": "Doe", 
    "email": "john.doe@example.com",
    "phone": "+1-555-0123"
  },
  "shippingAddress": {
    "address": "123 Main Street",
    "city": "New York", 
    "state": "NY",
    "zipCode": "10001",
    "country": "US"
  },
  "items": [
    {
      "id": 1,
      "name": "Wireless Bluetooth Headphones",
      "slug": "wireless-bluetooth-headphoness", 
      "price": 299.99,
      "quantity": 1,
      "comparePrice": 399.99
    }
  ],
  "pricing": {
    "subtotal": 299.99,
    "shipping": 0,
    "tax": 30.00,
    "codFee": 2.99,
    "total": 332.98
  },
  "paymentMethod": "cod"
};

const postData = JSON.stringify(testOrder);

const options = {
  hostname: 'localhost',
  port: 3003,
  path: '/api/orders',
  method: 'POST',
  headers: {
    'Content-Type': 'application/json',
    'Content-Length': Buffer.byteLength(postData)
  }
};

const req = https.request(options, (res) => {
  console.log(`statusCode: ${res.statusCode}`);
  
  let data = '';
  res.on('data', (chunk) => {
    data += chunk;
  });
  
  res.on('end', () => {
    console.log('Response:', JSON.parse(data));
  });
});

req.on('error', (error) => {
  console.error('Error:', error);
});

req.write(postData);
req.end();