const Loki = require('lokijs');
const path = require('path');

const dbPath = path.join(process.cwd(), 'users.db');

async function testDirectUpdate() {
  console.log('Testing direct database update...');
  
  return new Promise((resolve, reject) => {
    const db = new Loki(dbPath, {
      persistenceMethod: 'fs',
      autoload: true,
      autoloadCallback: (err) => {
        if (err) {
          console.error('Error loading database:', err);
          reject(err);
          return;
        }
        
        try {
          const ordersCollection = db.getCollection('orders');
          
          if (!ordersCollection) {
            console.log('Orders collection not found');
            resolve();
            return;
          }
          
          console.log('Total orders in collection:', ordersCollection.data.length);
          
          // Find the specific order
          const order = ordersCollection.findOne({ orderNumber: 'ORD-20251020-5113' });
          
          if (!order) {
            console.log('Order ORD-20251020-5113 not found');
            resolve();
            return;
          }
          
          console.log('Current order status:', order.orderStatus);
          
          // Update the order status
          order.orderStatus = 'cancelled';
          order.updatedAt = new Date().toISOString();
          
          // Update in collection
          ordersCollection.update(order);
          
          // Save database
          db.saveDatabase((saveErr) => {
            if (saveErr) {
              console.error('Error saving database:', saveErr);
              reject(saveErr);
            } else {
              console.log('Order status updated to: cancelled');
              console.log('Updated at:', order.updatedAt);
              resolve();
            }
          });
          
        } catch (error) {
          console.error('Error during update:', error);
          reject(error);
        }
      }
    });
  });
}

testDirectUpdate().catch(console.error);