const fetch = require('node-fetch');

async function testCompleteFilterScenario() {
    console.log('🧪 Testing complete category filter scenario...\n');
    
    try {
        // Get categories
        const categoriesResponse = await fetch('http://localhost:3000/api/categories');
        const categoriesData = await categoriesResponse.json();
        
        // Get subcategories  
        const subcategoriesResponse = await fetch('http://localhost:3000/api/subcategories');
        const subcategoriesData = await subcategoriesResponse.json();
        
        if (!categoriesData.categories || !subcategoriesData.subcategories) {
            console.log('❌ Failed to fetch data');
            return;
        }
        
        console.log(`📊 Data loaded: ${categoriesData.categories.length} categories, ${subcategoriesData.subcategories.length} subcategories\n`);
        
        // Test filtering for first few categories
        const testCategories = categoriesData.categories.slice(0, 5);
        
        console.log('🔍 Testing filters:');
        testCategories.forEach(category => {
            const categoryId = category.id; // This should be a string
            const matchingSubcategories = subcategoriesData.subcategories.filter(sub => 
                sub.categoryId === categoryId
            );
            
            console.log(`  📂 ${category.name} (ID: ${categoryId}): ${matchingSubcategories.length} subcategories`);
            
            if (matchingSubcategories.length > 0) {
                console.log(`     Sample: ${matchingSubcategories.slice(0, 2).map(s => s.name).join(', ')}`);
            }
        });
        
        console.log('\n✅ Category filter test completed!');
        
    } catch (error) {
        console.error('❌ Error:', error.message);
        console.log('Note: Make sure npm run dev is running on port 3000');
    }
}

testCompleteFilterScenario();