const http = require('http');

// Quick API test
function testAPI() {
  console.log('🧪 Testing API connectivity...');
  
  // Test GET /api/orders
  const options = {
    hostname: 'localhost',
    port: 3001,
    path: '/api/orders',
    method: 'GET'
  };

  const req = http.request(options, (res) => {
    let data = '';
    res.on('data', (chunk) => { data += chunk; });
    res.on('end', () => {
      console.log(`📥 GET /api/orders - Status: ${res.statusCode}`);
      if (res.statusCode === 200) {
        const orders = JSON.parse(data);
        console.log(`✅ API Working! Found ${orders.length} orders`);
        
        // Find our test order
        const testOrder = orders.find(o => o.orderNumber === 'ORD-20251021-8830');
        if (testOrder) {
          console.log(`🎯 Test order found: ${testOrder.orderNumber} - Status: ${testOrder.orderStatus}`);
          
          // Now test PATCH
          testPatchAPI(testOrder.orderNumber, testOrder.orderStatus);
        } else {
          console.log('⚠️ Test order ORD-20251021-8830 not found in API response');
        }
      } else {
        console.log('❌ API Error:', data);
      }
    });
  });

  req.on('error', (error) => {
    console.error('❌ API Test failed:', error.message);
  });

  req.end();
}

function testPatchAPI(orderNumber, currentStatus) {
  console.log(`\n🧪 Testing PATCH API for order: ${orderNumber}`);
  
  const newStatus = currentStatus === 'pending' ? 'processing' : 'pending';
  const updateData = JSON.stringify({ orderStatus: newStatus });

  const options = {
    hostname: 'localhost',
    port: 3001,
    path: `/api/orders/${orderNumber}`,
    method: 'PATCH',
    headers: {
      'Content-Type': 'application/json',
      'Content-Length': Buffer.byteLength(updateData)
    }
  };

  const req = http.request(options, (res) => {
    let data = '';
    res.on('data', (chunk) => { data += chunk; });
    res.on('end', () => {
      console.log(`📥 PATCH /api/orders/${orderNumber} - Status: ${res.statusCode}`);
      if (res.statusCode === 200) {
        console.log('✅ PATCH API Working!');
        console.log('📝 Response:', data);
      } else {
        console.log('❌ PATCH API Error:', data);
      }
    });
  });

  req.on('error', (error) => {
    console.error('❌ PATCH API Test failed:', error.message);
  });

  req.write(updateData);
  req.end();
}

// Wait a moment for server to be ready
setTimeout(testAPI, 2000);