const http = require('http');

async function testActionButtons() {
  console.log('Testing action button functionality...');
  
  // Test updating one of the pending orders to processing
  const updateData = JSON.stringify({ orderStatus: 'processing' });

  const options = {
    hostname: 'localhost',
    port: 3000,
    path: '/api/orders/ORD-20251020-8826', // Update one of the pending orders
    method: 'PATCH',
    headers: {
      'Content-Type': 'application/json',
      'Content-Length': Buffer.byteLength(updateData)
    }
  };

  return new Promise((resolve, reject) => {
    const req = http.request(options, (res) => {
      let data = '';
      res.on('data', (chunk) => { data += chunk; });
      res.on('end', () => {
        console.log('Response Status:', res.statusCode);
        if (res.statusCode === 200) {
          const result = JSON.parse(data);
          console.log('✅ Order status updated successfully');
          console.log('Order:', result.order?.orderNumber);
          console.log('New Status:', result.order?.orderStatus);
        } else {
          console.log('❌ Failed to update order:', data);
        }
        resolve({ status: res.statusCode, data });
      });
    });

    req.on('error', (error) => {
      console.error('❌ Request failed:', error.message);
      reject(error);
    });

    req.write(updateData);
    req.end();
  });
}

// Wait for server to be ready, then test
setTimeout(async () => {
  try {
    await testActionButtons();
    
    // Check database after update
    console.log('\n--- Database Status After Update ---');
    const fs = require('fs');
    const data = JSON.parse(fs.readFileSync('users.db', 'utf8'));
    const orders = data.collections.find(c => c.name === 'orders');
    const updatedOrder = orders.data.find(order => order.orderNumber === 'ORD-20251020-8826');
    
    if (updatedOrder) {
      console.log('✅ Database Updated');
      console.log('Order Number:', updatedOrder.orderNumber);
      console.log('Status:', updatedOrder.orderStatus);
      console.log('Updated At:', updatedOrder.updatedAt);
    } else {
      console.log('❌ Order not found in database');
    }
  } catch (error) {
    console.error('Test failed:', error.message);
  }
}, 2000);