import Loki from 'lokijs';

let db: Loki | null = null;

export interface User {
  id?: number;
  email: string;
  password: string;
  createdAt: Date;
}

export function getDatabase(): Promise<Loki> {
  return new Promise((resolve, reject) => {
    if (db) {
      resolve(db);
      return;
    }

    db = new Loki('users.db', {
      autoload: true,
      autoloadCallback: () => {
        // Get or create users collection
        let users = db!.getCollection<User>('users');
        if (!users) {
          users = db!.addCollection<User>('users', { indices: ['email'] });
          
          // Add a default user for testing
          const bcrypt = require('bcryptjs');
          const hashedPassword = bcrypt.hashSync('password123', 10);
          
          users.insert({
            email: 'test@example.com',
            password: hashedPassword,
            createdAt: new Date()
          });
          
          db!.saveDatabase();
        }
        resolve(db!);
      },
      autosave: true,
      autosaveInterval: 4000
    });
  });
}

export async function getUsersCollection() {
  const database = await getDatabase();
  return database.getCollection<User>('users');
}