const loki = require('lokijs');

const showVariableProducts = () => {
  const db = new loki('users.db');
  
  db.loadDatabase({}, () => {
    const products = db.getCollection('products');
    if (!products) {
      console.log('No products collection found');
      return;
    }
    
    const variableProducts = products.find({ type: 'variable' });
    console.log('🎛️  TOP 5 VARIABLE PRODUCTS');
    console.log('============================\n');
    
    variableProducts.slice(0, 5).forEach((product, i) => {
      console.log(`${i + 1}. 📦 ${product.name}`);
      console.log(`   🆔 ID: ${product.id}`);
      console.log(`   🔗 Slug: ${product.slug}`);
      console.log(`   📂 Category: ${product.categoryName}`);
      console.log(`   💰 Price Range: $${product.priceRange?.min || 'N/A'} - $${product.priceRange?.max || 'N/A'}`);
      
      if (product.attributes && product.attributes.length > 0) {
        console.log(`   🎨 Attributes:`);
        product.attributes.forEach(attr => {
          console.log(`      • ${attr.name}: ${attr.values.join(', ')}`);
        });
      }
      
      console.log(`   📋 Total Variants: ${product.variants?.length || 0}`);
      console.log(`   ⭐ Featured: ${product.isFeatured ? 'Yes' : 'No'}`);
      console.log(`   ✅ Active: ${product.isActive ? 'Yes' : 'No'}`);
      
      if (product.variants && product.variants.length > 0) {
        console.log(`   🔧 VARIANTS (showing first 3):`);
        product.variants.slice(0, 3).forEach((variant, vi) => {
          const attrs = Object.entries(variant.attributes || {})
            .map(([key, value]) => `${key}: ${value}`)
            .join(', ');
          console.log(`      ${vi + 1}. ${attrs}`);
          console.log(`         💲 Price: $${variant.price}`);
          console.log(`         📦 Stock: ${variant.stockQuantity}`);
          console.log(`         🏷️  SKU: ${variant.sku}`);
        });
        if (product.variants.length > 3) {
          console.log(`      ... and ${product.variants.length - 3} more variants`);
        }
      }
      console.log('');
    });
    
    console.log(`\n📊 Summary: Showing 5 out of ${variableProducts.length} total variable products`);
  });
};

showVariableProducts();