const fs = require('fs');

async function removeDummyProducts() {
  console.log('🗑️  Starting to remove dummy products...');
  
  try {
    // Read the current database
    const dbPath = 'users.db';
    
    if (!fs.existsSync(dbPath)) {
      console.error('❌ Database file not found!');
      return;
    }
    
    const dbContent = fs.readFileSync(dbPath, 'utf8');
    const data = JSON.parse(dbContent);
    
    // Find products collection
    let productsCollection = data.collections.find(c => c.name === 'products');
    if (!productsCollection) {
      console.log('ℹ️  No products collection found.');
      return;
    }
    
    const originalCount = productsCollection.data.length;
    console.log(`📊 Current products count: ${originalCount}`);
    
    // Keep only the first 5 products (original products)
    // Assuming the dummy products start from ID 6 onwards
    const originalProducts = productsCollection.data.filter(product => product.id <= 5);
    
    console.log(`🔍 Found ${originalProducts.length} original products to keep`);
    console.log(`🗑️  Removing ${originalCount - originalProducts.length} dummy products...`);
    
    // Update the collection
    productsCollection.data = originalProducts;
    productsCollection.maxId = originalProducts.length > 0 ? Math.max(...originalProducts.map(p => p.id)) : 0;
    productsCollection.idIndex = originalProducts.map((_, index) => index);
    
    // Write back to database
    fs.writeFileSync(dbPath, JSON.stringify(data, null, 2));
    
    console.log('✅ Successfully removed dummy products!');
    console.log(`📊 Products remaining: ${productsCollection.data.length}`);
    
  } catch (error) {
    console.error('❌ Error removing dummy products:', error);
  }
}

// Check if script is run with --confirm flag
const args = process.argv.slice(2);
if (args.includes('--confirm')) {
  removeDummyProducts();
} else {
  console.log('⚠️  This script will remove all dummy products from the database.');
  console.log('To proceed, run: node remove-dummy-products.js --confirm');
}