const loki = require('lokijs');

const db = new loki('users.db');
db.loadDatabase({}, () => {
  const subcategories = db.getCollection('subcategories');
  
  // Add one more to Electronics
  const newSubcategory = {
    id: Date.now().toString() + Math.random().toString(36).substr(2, 9),
    name: 'Cables & Chargers',
    description: 'USB cables, phone chargers and power accessories',
    slug: 'cables-chargers',
    categoryId: '1',
    icon: '🔌',
    isActive: true,
    createdAt: new Date().toISOString(),
    updatedAt: new Date().toISOString()
  };
  
  subcategories.insert(newSubcategory);
  console.log('✅ Added Cables & Chargers to Electronics');
  
  db.saveDatabase(() => {
    console.log('\nFinal verification - ALL CATEGORIES:');
    console.log('====================================');
    
    const categories = db.getCollection('categories');
    const allCategories = categories.find({});
    const allSubcategories = subcategories.find({});
    
    let categoriesWithoutEnoughSubs = 0;
    
    allCategories.forEach(cat => {
      const count = allSubcategories.filter(sub => sub.categoryId === cat.id).length;
      if (count < 5) {
        console.log(`❌ ${cat.name}: ${count} subcategories (NEEDS MORE)`);
        categoriesWithoutEnoughSubs++;
      } else {
        console.log(`✅ ${cat.name}: ${count} subcategories`);
      }
    });
    
    console.log(`\nSummary:`);
    console.log(`========`);
    console.log(`Total categories: ${allCategories.length}`);
    console.log(`Total subcategories: ${allSubcategories.length}`);
    console.log(`Categories with less than 5 subcategories: ${categoriesWithoutEnoughSubs}`);
    
    if (categoriesWithoutEnoughSubs === 0) {
      console.log(`\n🎉 SUCCESS: All categories now have at least 5 subcategories!`);
    } else {
      console.log(`\n⚠️  WARNING: ${categoriesWithoutEnoughSubs} categories still need more subcategories`);
    }
  });
});