const Loki = require('lokijs');

console.log("🎨 Setting proper icons and descriptions for all categories...");

const db = new Loki("users.db", {
  autoload: true,
  autoloadCallback: function () {
    const categories = db.getCollection("categories");
    
    if (!categories) {
      console.log("❌ Categories collection not found.");
      process.exit(1);
    }

    // Define proper data for each category
    const categoryData = {
      'Electronics': {
        icon: '📱',
        description: 'Electronic devices and gadgets for modern life',
        slug: 'electronics'
      },
      'Fashion': {
        icon: '👕',
        description: 'Clothing, accessories, and fashion items',
        slug: 'fashion'
      },
      'Home & Kitchen': {
        icon: '🏠',
        description: 'Home improvement and kitchen essentials',
        slug: 'home-kitchen'
      },
      'Documents / Files': {
        icon: '📁',
        description: 'Document storage, file management, and digital organization',
        slug: 'documents-files'
      },
      'Shopping / Retail': {
        icon: '🛍️',
        description: 'General retail and shopping services',
        slug: 'shopping-retail'
      },
      'Clothing': {
        icon: '👕',
        description: 'Fashion apparel for all ages and occasions',
        slug: 'clothing'
      },
      'Footwear': {
        icon: '👟',
        description: 'Shoes and accessories for all occasions',
        slug: 'footwear'
      },
      'Mobile Devices': {
        icon: '📱',
        description: 'Smartphones, tablets, and mobile accessories',
        slug: 'mobile-devices'
      },
      'Computers / Tech': {
        icon: '💻',
        description: 'Computers, technology, and digital devices',
        slug: 'computers-tech'
      },
      'Home / Real Estate': {
        icon: '🏠',
        description: 'Home improvement, real estate, and living spaces',
        slug: 'home-real-estate'
      },
      'Gaming': {
        icon: '🎮',
        description: 'Video games, consoles, and gaming accessories',
        slug: 'gaming'
      },
      'Books / Education': {
        icon: '📚',
        description: 'Books, educational materials, and learning resources',
        slug: 'books-education'
      },
      'Music': {
        icon: '🎵',
        description: 'Musical instruments, audio equipment, and music',
        slug: 'music'
      },
      'Food': {
        icon: '🍔',
        description: 'Food products, snacks, and culinary items',
        slug: 'food'
      },
      'Coffee / Beverages': {
        icon: '☕',
        description: 'Coffee, tea, drinks, and beverage accessories',
        slug: 'coffee-beverages'
      }
    };

    let updatedCount = 0;

    categories.data.forEach((category) => {
      const categoryInfo = categoryData[category.name];
      if (categoryInfo) {
        let needsUpdate = false;

        if (category.icon !== categoryInfo.icon) {
          category.icon = categoryInfo.icon;
          needsUpdate = true;
        }

        if (category.description !== categoryInfo.description) {
          category.description = categoryInfo.description;
          needsUpdate = true;
        }

        if (category.slug !== categoryInfo.slug) {
          category.slug = categoryInfo.slug;
          needsUpdate = true;
        }

        if (needsUpdate) {
          category.updatedAt = new Date().toISOString();
          categories.update(category);
          updatedCount++;
          console.log(`✅ Updated: ${category.name} -> ${category.icon} ${category.description}`);
        }
      }
    });

    db.saveDatabase(() => {
      console.log(`\n✅ Category enhancement complete!`);
      console.log(`📊 Enhanced ${updatedCount} categories`);
      
      // Show the first few categories
      console.log("\n📋 First 5 categories after enhancement:");
      categories.data.slice(0, 5).forEach((cat, index) => {
        console.log(`${index + 1}. ${cat.icon} ${cat.name} (/${cat.slug})`);
        console.log(`   ${cat.description}`);
      });
      
      process.exit(0);
    });
  },
});