const http = require('http');

// Create a test order with pending status
const testOrder = {
  customerInfo: {
    firstName: 'Test',
    lastName: 'User',
    email: 'test.user@example.com',
    phone: '555-0123'
  },
  shippingAddress: {
    address: '123 Test Street',
    city: 'Test City',
    state: 'TS',
    zipCode: '12345',
    country: 'US'
  },
  items: [
    {
      id: 1,
      name: 'Test Product',
      slug: 'test-product',
      price: 99.99,
      quantity: 1
    }
  ],
  pricing: {
    subtotal: 99.99,
    shipping: 5.00,
    tax: 10.00,
    total: 114.99
  },
  paymentMethod: 'card'
};

const postData = JSON.stringify(testOrder);

const options = {
  hostname: 'localhost',
  port: 3001,
  path: '/api/orders',
  method: 'POST',
  headers: {
    'Content-Type': 'application/json',
    'Content-Length': Buffer.byteLength(postData)
  }
};

console.log('Creating test order...');

const req = http.request(options, (res) => {
  let data = '';
  res.on('data', (chunk) => { data += chunk; });
  res.on('end', () => {
    if (res.statusCode === 200 || res.statusCode === 201) {
      const result = JSON.parse(data);
      console.log('✅ Test order created successfully!');
      console.log('Order Number:', result.orderNumber);
      console.log('Status:', result.orderStatus || 'pending');
    } else {
      console.log('❌ Failed to create test order:', res.statusCode, data);
    }
  });
});

req.on('error', (error) => {
  console.error('❌ Error creating test order:', error.message);
});

req.write(postData);
req.end();