const Loki = require('lokijs');
const path = require('path');

const dbPath = path.join(process.cwd(), 'users.db');

function createTestOrder() {
  return new Promise((resolve, reject) => {
    const db = new Loki(dbPath, {
      persistenceMethod: 'fs',
      autoload: true,
      autoloadCallback: (err) => {
        if (err) {
          console.error('Error loading database:', err);
          reject(err);
          return;
        }
        
        try {
          let ordersCollection = db.getCollection('orders');
          
          if (!ordersCollection) {
            ordersCollection = db.addCollection('orders');
          }
          
          // Generate order number
          const orderNumber = `ORD-${new Date().toISOString().split('T')[0].replace(/-/g, '')}-${Math.floor(Math.random() * 10000).toString().padStart(4, '0')}`;
          
          const testOrder = {
            orderNumber,
            customerInfo: {
              firstName: 'Test',
              lastName: 'Customer',
              email: 'test.customer@example.com',
              phone: '555-0123'
            },
            shippingAddress: {
              address: '123 Test Street',
              city: 'Test City',
              state: 'TS',
              zipCode: '12345',
              country: 'US'
            },
            items: [
              {
                id: 1,
                name: 'Test Product for Button Testing',
                slug: 'test-product-button',
                price: 49.99,
                quantity: 2
              }
            ],
            pricing: {
              subtotal: 99.98,
              shipping: 5.00,
              tax: 10.50,
              total: 115.48
            },
            paymentMethod: 'card',
            orderStatus: 'pending',
            paymentStatus: 'pending',
            createdAt: new Date().toISOString(),
            updatedAt: new Date().toISOString()
          };
          
          // Insert the order
          ordersCollection.insert(testOrder);
          
          // Save database
          db.saveDatabase((saveErr) => {
            if (saveErr) {
              console.error('Error saving database:', saveErr);
              reject(saveErr);
            } else {
              console.log('✅ Test order created successfully!');
              console.log('Order Number:', testOrder.orderNumber);
              console.log('Status:', testOrder.orderStatus);
              console.log('Customer:', `${testOrder.customerInfo.firstName} ${testOrder.customerInfo.lastName}`);
              resolve(testOrder);
            }
          });
          
        } catch (error) {
          console.error('Error creating test order:', error);
          reject(error);
        }
      }
    });
  });
}

createTestOrder().catch(console.error);