const loki = require('lokijs');

// Initialize database
const db = new loki('users.db');

db.loadDatabase({}, () => {
  console.log('Database loaded successfully');
  
  let subcategories = db.getCollection('subcategories');
  
  if (!subcategories) {
    console.error('Subcategories collection not found');
    return;
  }

  // Additional subcategories to ensure all categories have at least 6
  const additionalSubcategories = [
    // Electronics (categoryId: "1") - needs 4 more
    {
      name: 'Gaming Consoles',
      description: 'PlayStation, Xbox, Nintendo and gaming accessories',
      slug: 'gaming-consoles',
      categoryId: '1',
      icon: '🎮',
      isActive: true
    },
    {
      name: 'Smart Watches',
      description: 'Apple Watch, fitness trackers and wearables',
      slug: 'smart-watches',
      categoryId: '1',
      icon: '⌚',
      isActive: true
    },
    {
      name: 'TV & Home Theater',
      description: 'Smart TVs, sound systems and entertainment',
      slug: 'tv-home-theater',
      categoryId: '1',
      icon: '📺',
      isActive: true
    },
    {
      name: 'Computer Accessories',
      description: 'Keyboards, mice, monitors and PC accessories',
      slug: 'computer-accessories',
      categoryId: '1',
      icon: '⌨️',
      isActive: true
    },

    // Fashion (categoryId: "2") - needs 4 more
    {
      name: 'Activewear',
      description: 'Gym clothes, yoga wear and athletic fashion',
      slug: 'activewear',
      categoryId: '2',
      icon: '🏃',
      isActive: true
    },
    {
      name: 'Formal Wear',
      description: 'Suits, formal dresses and business attire',
      slug: 'formal-wear',
      categoryId: '2',
      icon: '🤵',
      isActive: true
    },
    {
      name: 'Swimwear',
      description: 'Bikinis, swimsuits and beach wear',
      slug: 'swimwear',
      categoryId: '2',
      icon: '👙',
      isActive: true
    },
    {
      name: 'Lingerie & Underwear',
      description: 'Intimate apparel and undergarments',
      slug: 'lingerie-underwear',
      categoryId: '2',
      icon: '👙',
      isActive: true
    },

    // Home & Garden (categoryId: "3") - needs 3 more
    {
      name: 'Lighting',
      description: 'Lamps, LED lights and home lighting solutions',
      slug: 'lighting',
      categoryId: '3',
      icon: '💡',
      isActive: true
    },
    {
      name: 'Tools & Hardware',
      description: 'Hand tools, power tools and hardware supplies',
      slug: 'tools-hardware',
      categoryId: '3',
      icon: '🔨',
      isActive: true
    },
    {
      name: 'Cleaning Supplies',
      description: 'Household cleaners and cleaning equipment',
      slug: 'cleaning-supplies',
      categoryId: '3',
      icon: '🧽',
      isActive: true
    },

    // Sports (categoryId: "4") - needs 5 more
    {
      name: 'Running & Cardio',
      description: 'Running shoes, cardio equipment and accessories',
      slug: 'running-cardio',
      categoryId: '4',
      icon: '🏃',
      isActive: true
    },
    {
      name: 'Strength Training',
      description: 'Weights, resistance bands and strength equipment',
      slug: 'strength-training',
      categoryId: '4',
      icon: '🏋️',
      isActive: true
    },
    {
      name: 'Yoga & Pilates',
      description: 'Yoga mats, blocks and mindfulness equipment',
      slug: 'yoga-pilates',
      categoryId: '4',
      icon: '🧘',
      isActive: true
    },
    {
      name: 'Golf',
      description: 'Golf clubs, balls and golfing accessories',
      slug: 'golf',
      categoryId: '4',
      icon: '⛳',
      isActive: true
    },
    {
      name: 'Tennis & Racquet Sports',
      description: 'Tennis rackets, balls and court equipment',
      slug: 'tennis-racquet-sports',
      categoryId: '4',
      icon: '🎾',
      isActive: true
    }
  ];

  // Add each subcategory
  let addedCount = 0;
  additionalSubcategories.forEach(subcategory => {
    try {
      // Check if subcategory already exists
      const existingSubcategory = subcategories.findOne({ 
        slug: subcategory.slug 
      });

      if (!existingSubcategory) {
        // Generate unique ID
        subcategory.id = Date.now().toString() + Math.random().toString(36).substr(2, 9);
        subcategory.createdAt = new Date().toISOString();
        subcategory.updatedAt = new Date().toISOString();

        subcategories.insert(subcategory);
        addedCount++;
        console.log(`✅ Added subcategory: ${subcategory.name} to category ${subcategory.categoryId}`);
      } else {
        console.log(`⚠️  Subcategory already exists: ${subcategory.name}`);
      }
    } catch (error) {
      console.error(`❌ Error adding subcategory ${subcategory.name}:`, error);
    }
  });

  // Save the database
  db.saveDatabase((err) => {
    if (err) {
      console.error('Error saving database:', err);
    } else {
      console.log(`\n🎉 Successfully added ${addedCount} new subcategories!`);
      
      // Final verification for first 4 categories
      console.log('\nFinal verification for first 4 categories:');
      console.log('==========================================');
      
      for (let i = 1; i <= 4; i++) {
        const subs = subcategories.find({ categoryId: i.toString() });
        console.log(`Category ${i}: ${subs.length} subcategories`);
        subs.forEach(sub => {
          console.log(`  - ${sub.name}`);
        });
      }
      
      const totalSubcategories = subcategories.count();
      console.log(`\nTotal subcategories: ${totalSubcategories}`);
    }
  });
});