const loki = require('lokijs');
const db = new loki('users.db');
db.loadDatabase({}, () => {
  console.log('Database collections:');
  console.log(db.listCollections().map(c => c.name));
  
  const categories = db.getCollection('categories');
  const subcategories = db.getCollection('subcategories');
  const products = db.getCollection('products');
  
  console.log('Categories collection exists:', !!categories);
  console.log('Subcategories collection exists:', !!subcategories);
  console.log('Products collection exists:', !!products);
  
  if (categories) console.log('Categories count:', categories.count());
  if (subcategories) console.log('Subcategories count:', subcategories.count());
  if (products) console.log('Products count:', products.count());
});