const loki = require('lokijs');

// Initialize database
const db = new loki('users.db');
db.loadDatabase({}, function() {
    console.log('Database loaded');
    
    // Get collections
    const categoriesCollection = db.getCollection('categories');
    const subcategoriesCollection = db.getCollection('subcategories');
    
    if (!categoriesCollection || !subcategoriesCollection) {
        console.log('Collections not found');
        return;
    }
    
    // Get all categories
    const categories = categoriesCollection.find({});
    console.log(`Total categories: ${categories.length}`);
    
    // Get all subcategories
    const subcategories = subcategoriesCollection.find({});
    console.log(`Total subcategories: ${subcategories.length}`);
    
    // Find categories without subcategories
    const categoriesWithoutSubcategories = [];
    
    categories.forEach(category => {
        const categorySubcategories = subcategories.filter(sub => sub.categoryId === category.$loki);
        if (categorySubcategories.length === 0) {
            categoriesWithoutSubcategories.push({
                id: category.$loki,
                name: category.name,
                slug: category.slug
            });
        }
    });
    
    console.log('\n=== CATEGORIES WITHOUT SUBCATEGORIES ===');
    if (categoriesWithoutSubcategories.length === 0) {
        console.log('All categories have subcategories!');
    } else {
        console.log(`Found ${categoriesWithoutSubcategories.length} categories without subcategories:`);
        categoriesWithoutSubcategories.forEach(cat => {
            console.log(`- ${cat.name} (ID: ${cat.id}, Slug: ${cat.slug})`);
        });
    }
    
    // Also show categories with their subcategory counts
    console.log('\n=== CATEGORY SUBCATEGORY COUNTS ===');
    categories.forEach(category => {
        const count = subcategories.filter(sub => sub.categoryId === category.$loki).length;
        console.log(`${category.name}: ${count} subcategories`);
    });
});