const loki = require('lokijs');

// Initialize database
const db = new loki('users.db');

db.loadDatabase({}, () => {
  console.log('Database loaded successfully');
  
  let categories = db.getCollection('categories');
  let subcategories = db.getCollection('subcategories');
  
  if (!categories || !subcategories) {
    console.error('Collections not found');
    return;
  }

  // Function to create slug from name
  function createSlug(name) {
    return name.toLowerCase()
      .replace(/[^a-z0-9 -]/g, '')
      .replace(/\s+/g, '-')
      .replace(/-+/g, '-')
      .trim('-');
  }

  // Additional subcategories for the 4 categories that are missing them
  const missingSubcategories = [
    // Electronics (categoryId: "1")
    {
      name: 'Smartphones',
      description: 'Latest smartphones and mobile devices',
      slug: 'smartphones',
      categoryId: '1',
      icon: '📱',
      isActive: true
    },
    {
      name: 'Tablets',
      description: 'iPads, Android tablets and accessories',
      slug: 'tablets',
      categoryId: '1',
      icon: '📱',
      isActive: true
    },
    {
      name: 'Laptops',
      description: 'Notebooks, ultrabooks and gaming laptops',
      slug: 'laptops',
      categoryId: '1',
      icon: '💻',
      isActive: true
    },
    {
      name: 'Audio & Headphones',
      description: 'Headphones, speakers and audio equipment',
      slug: 'audio-headphones',
      categoryId: '1',
      icon: '🎧',
      isActive: true
    },
    {
      name: 'Smart Home',
      description: 'IoT devices and smart home automation',
      slug: 'smart-home',
      categoryId: '1',
      icon: '🏠',
      isActive: true
    },
    {
      name: 'Cameras',
      description: 'Digital cameras and photography equipment',
      slug: 'cameras',
      categoryId: '1',
      icon: '📷',
      isActive: true
    },

    // Fashion (categoryId: "2")
    {
      name: 'Mens Clothing',
      description: 'Shirts, pants, jackets and mens fashion',
      slug: 'mens-clothing',
      categoryId: '2',
      icon: '👔',
      isActive: true
    },
    {
      name: 'Womens Clothing',
      description: 'Dresses, tops, pants and womens fashion',
      slug: 'womens-clothing',
      categoryId: '2',
      icon: '👗',
      isActive: true
    },
    {
      name: 'Shoes',
      description: 'Sneakers, boots, heels and footwear',
      slug: 'shoes',
      categoryId: '2',
      icon: '👟',
      isActive: true
    },
    {
      name: 'Accessories',
      description: 'Bags, belts, hats and fashion accessories',
      slug: 'fashion-accessories',
      categoryId: '2',
      icon: '👜',
      isActive: true
    },
    {
      name: 'Jewelry',
      description: 'Rings, necklaces, earrings and fine jewelry',
      slug: 'fashion-jewelry',
      categoryId: '2',
      icon: '💍',
      isActive: true
    },
    {
      name: 'Watches',
      description: 'Smart watches, luxury watches and timepieces',
      slug: 'watches',
      categoryId: '2',
      icon: '⌚',
      isActive: true
    },

    // Home & Garden (categoryId: "3")
    {
      name: 'Furniture',
      description: 'Sofas, chairs, tables and home furniture',
      slug: 'home-furniture',
      categoryId: '3',
      icon: '🛋️',
      isActive: true
    },
    {
      name: 'Home Decor',
      description: 'Wall art, decorations and home styling',
      slug: 'home-decor',
      categoryId: '3',
      icon: '🖼️',
      isActive: true
    },
    {
      name: 'Kitchen & Dining',
      description: 'Cookware, utensils and kitchen appliances',
      slug: 'kitchen-dining',
      categoryId: '3',
      icon: '🍳',
      isActive: true
    },
    {
      name: 'Bedding & Bath',
      description: 'Sheets, towels, bathroom and bedroom essentials',
      slug: 'bedding-bath',
      categoryId: '3',
      icon: '🛏️',
      isActive: true
    },
    {
      name: 'Garden & Outdoor',
      description: 'Plants, garden tools and outdoor living',
      slug: 'garden-outdoor',
      categoryId: '3',
      icon: '🌱',
      isActive: true
    },
    {
      name: 'Storage & Organization',
      description: 'Shelving, containers and organization solutions',
      slug: 'storage-organization',
      categoryId: '3',
      icon: '📦',
      isActive: true
    },

    // Sports (categoryId: "4")
    {
      name: 'Fitness Equipment',
      description: 'Weights, cardio machines and workout gear',
      slug: 'fitness-equipment',
      categoryId: '4',
      icon: '🏋️',
      isActive: true
    },
    {
      name: 'Athletic Wear',
      description: 'Sportswear, activewear and workout clothing',
      slug: 'athletic-wear',
      categoryId: '4',
      icon: '👕',
      isActive: true
    },
    {
      name: 'Team Sports',
      description: 'Football, basketball, soccer and team equipment',
      slug: 'team-sports',
      categoryId: '4',
      icon: '⚽',
      isActive: true
    },
    {
      name: 'Outdoor Recreation',
      description: 'Camping, hiking and outdoor adventure gear',
      slug: 'outdoor-recreation',
      categoryId: '4',
      icon: '🏕️',
      isActive: true
    },
    {
      name: 'Water Sports',
      description: 'Swimming, surfing and water activity equipment',
      slug: 'water-sports',
      categoryId: '4',
      icon: '🏊',
      isActive: true
    },
    {
      name: 'Cycling',
      description: 'Bikes, helmets and cycling accessories',
      slug: 'cycling',
      categoryId: '4',
      icon: '🚴',
      isActive: true
    }
  ];

  // Add more subcategories to categories that have fewer than 5
  const additionalSubcategories = [
    // Documents / Files (5) - currently has 4, add 2 more
    {
      name: 'Digital Storage',
      description: 'Cloud storage and digital file management',
      slug: 'digital-storage',
      categoryId: '5',
      icon: '☁️',
      isActive: true
    },
    {
      name: 'Printing & Scanning',
      description: 'Printers, scanners and document processing',
      slug: 'printing-scanning',
      categoryId: '5',
      icon: '🖨️',
      isActive: true
    },

    // Shopping / Retail (6) - currently has 4, add 2 more
    {
      name: 'Gift Cards',
      description: 'Digital and physical gift cards',
      slug: 'gift-cards',
      categoryId: '6',
      icon: '🎁',
      isActive: true
    },
    {
      name: 'Bulk Orders',
      description: 'Wholesale and bulk purchasing options',
      slug: 'bulk-orders',
      categoryId: '6',
      icon: '📦',
      isActive: true
    }
  ];

  // Combine all subcategories to add
  const allNewSubcategories = [...missingSubcategories, ...additionalSubcategories];

  // Add each subcategory
  let addedCount = 0;
  allNewSubcategories.forEach(subcategory => {
    try {
      // Check if subcategory already exists
      const existingSubcategory = subcategories.findOne({ 
        slug: subcategory.slug 
      });

      if (!existingSubcategory) {
        // Generate unique ID
        subcategory.id = Date.now().toString() + Math.random().toString(36).substr(2, 9);
        subcategory.createdAt = new Date().toISOString();
        subcategory.updatedAt = new Date().toISOString();

        subcategories.insert(subcategory);
        addedCount++;
        console.log(`✅ Added subcategory: ${subcategory.name} to category ${subcategory.categoryId}`);
      } else {
        console.log(`⚠️  Subcategory already exists: ${subcategory.name}`);
      }
    } catch (error) {
      console.error(`❌ Error adding subcategory ${subcategory.name}:`, error);
    }
  });

  // Save the database
  db.saveDatabase((err) => {
    if (err) {
      console.error('Error saving database:', err);
    } else {
      console.log(`\n🎉 Successfully added ${addedCount} new subcategories!`);
      
      // Final verification
      const allCategories = categories.find({});
      const allSubcategories = subcategories.find({});
      
      console.log('\nFinal verification:');
      console.log('==================');
      
      allCategories.forEach(cat => {
        const count = allSubcategories.filter(sub => sub.categoryId === cat.id).length;
        console.log(`${cat.name}: ${count} subcategories`);
      });
      
      console.log(`\nTotal categories: ${allCategories.length}`);
      console.log(`Total subcategories: ${allSubcategories.length}`);
    }
  });
});