const Loki = require('lokijs');

console.log("📦 Adding missing categories and subcategories...");

const db = new Loki("users.db", {
  autoload: true,
  autoloadCallback: function () {
    let categories = db.getCollection("categories");
    if (!categories) {
      categories = db.addCollection("categories");
    }

    let subcategories = db.getCollection("subcategories");
    if (!subcategories) {
      subcategories = db.addCollection("subcategories");
    }

    const missingCategories = [
      {
        name: 'Documents / Files',
        description: 'Document storage, file management, and digital organization',
        icon: '📁',
        slug: 'documents-files',
        isActive: true,
        sortOrder: 1,
        subcategories: [
          { name: 'Digital Documents', description: 'PDFs, Word files, presentations', icon: '📄', slug: 'digital-documents' },
          { name: 'Cloud Storage', description: 'Online file storage solutions', icon: '☁️', slug: 'cloud-storage' },
          { name: 'File Organization', description: 'Folders, labels, sorting systems', icon: '🗂️', slug: 'file-organization' },
          { name: 'Backup Solutions', description: 'Data backup and recovery', icon: '💾', slug: 'backup-solutions' }
        ]
      },
      {
        name: 'Shopping / Retail',
        description: 'General retail and shopping services',
        icon: '🛍️',
        slug: 'shopping-retail',
        isActive: true,
        sortOrder: 2,
        subcategories: [
          { name: 'Online Shopping', description: 'E-commerce platforms and stores', icon: '🛒', slug: 'online-shopping' },
          { name: 'Marketplace', description: 'Multi-vendor platforms', icon: '🏪', slug: 'marketplace' },
          { name: 'Retail Stores', description: 'Physical retail locations', icon: '🏬', slug: 'retail-stores' },
          { name: 'Shopping Tools', description: 'Price comparison, wishlists', icon: '🔍', slug: 'shopping-tools' }
        ]
      },
      {
        name: 'Clothing',
        description: 'Fashion apparel for all ages and occasions',
        icon: '👕',
        slug: 'clothing',
        isActive: true,
        sortOrder: 3,
        subcategories: [
          { name: 'Men\'s Clothing', description: 'Shirts, pants, suits, casual wear', icon: '👔', slug: 'mens-clothing' },
          { name: 'Women\'s Clothing', description: 'Dresses, tops, bottoms, formal wear', icon: '👗', slug: 'womens-clothing' },
          { name: 'Kids Clothing', description: 'Children\'s apparel and baby clothes', icon: '👶', slug: 'kids-clothing' },
          { name: 'Activewear', description: 'Sports and fitness clothing', icon: '🏃', slug: 'activewear' },
          { name: 'Underwear & Sleepwear', description: 'Intimates, pajamas, loungewear', icon: '🩲', slug: 'underwear-sleepwear' },
          { name: 'Outerwear', description: 'Jackets, coats, winter wear', icon: '🧥', slug: 'outerwear' }
        ]
      },
      {
        name: 'Footwear',
        description: 'Shoes and accessories for all occasions',
        icon: '👟',
        slug: 'footwear',
        isActive: true,
        sortOrder: 4,
        subcategories: [
          { name: 'Athletic Shoes', description: 'Running, training, sports shoes', icon: '👟', slug: 'athletic-shoes' },
          { name: 'Casual Shoes', description: 'Sneakers, loafers, everyday wear', icon: '👞', slug: 'casual-shoes' },
          { name: 'Formal Shoes', description: 'Dress shoes, heels, business wear', icon: '👠', slug: 'formal-shoes' },
          { name: 'Boots', description: 'Work boots, fashion boots, hiking boots', icon: '🥾', slug: 'boots' },
          { name: 'Sandals', description: 'Summer footwear, flip-flops', icon: '🩴', slug: 'sandals' },
          { name: 'Shoe Care', description: 'Cleaning supplies, shoe accessories', icon: '🧽', slug: 'shoe-care' }
        ]
      },
      {
        name: 'Mobile Devices',
        description: 'Smartphones, tablets, and mobile accessories',
        icon: '📱',
        slug: 'mobile-devices',
        isActive: true,
        sortOrder: 5,
        subcategories: [
          { name: 'Smartphones', description: 'Latest mobile phones and devices', icon: '📱', slug: 'smartphones' },
          { name: 'Tablets', description: 'iPads, Android tablets, e-readers', icon: '📟', slug: 'tablets' },
          { name: 'Phone Cases', description: 'Protective cases and covers', icon: '📱', slug: 'phone-cases' },
          { name: 'Chargers & Cables', description: 'Power banks, charging accessories', icon: '🔌', slug: 'chargers-cables' },
          { name: 'Screen Protectors', description: 'Tempered glass, privacy screens', icon: '🛡️', slug: 'screen-protectors' },
          { name: 'Mobile Accessories', description: 'Stands, grips, car mounts', icon: '🔧', slug: 'mobile-accessories' }
        ]
      },
      {
        name: 'Computers / Tech',
        description: 'Computers, technology, and digital devices',
        icon: '💻',
        slug: 'computers-tech',
        isActive: true,
        sortOrder: 6,
        subcategories: [
          { name: 'Laptops', description: 'Notebooks, ultrabooks, gaming laptops', icon: '💻', slug: 'laptops' },
          { name: 'Desktop Computers', description: 'PCs, workstations, all-in-ones', icon: '🖥️', slug: 'desktop-computers' },
          { name: 'Computer Components', description: 'CPU, GPU, RAM, storage', icon: '🧮', slug: 'computer-components' },
          { name: 'Peripherals', description: 'Keyboards, mice, monitors', icon: '⌨️', slug: 'peripherals' },
          { name: 'Software', description: 'Operating systems, applications', icon: '💿', slug: 'software' },
          { name: 'Networking', description: 'Routers, cables, WiFi equipment', icon: '📡', slug: 'networking' }
        ]
      },
      {
        name: 'Home / Real Estate',
        description: 'Home improvement, real estate, and living spaces',
        icon: '🏠',
        slug: 'home-real-estate',
        isActive: true,
        sortOrder: 7,
        subcategories: [
          { name: 'Home Decor', description: 'Wall art, decorative items, plants', icon: '🖼️', slug: 'home-decor' },
          { name: 'Home Improvement', description: 'Tools, hardware, renovation supplies', icon: '🔨', slug: 'home-improvement' },
          { name: 'Garden & Outdoor', description: 'Plants, gardening tools, outdoor decor', icon: '🌱', slug: 'garden-outdoor' },
          { name: 'Lighting', description: 'Lamps, fixtures, smart lighting', icon: '💡', slug: 'lighting' },
          { name: 'Kitchen & Dining', description: 'Cookware, dinnerware, kitchen gadgets', icon: '🍽️', slug: 'kitchen-dining' },
          { name: 'Bathroom', description: 'Fixtures, accessories, storage', icon: '🚿', slug: 'bathroom' }
        ]
      },
      {
        name: 'Gaming',
        description: 'Video games, consoles, and gaming accessories',
        icon: '🎮',
        slug: 'gaming',
        isActive: true,
        sortOrder: 8,
        subcategories: [
          { name: 'Gaming Consoles', description: 'PlayStation, Xbox, Nintendo Switch', icon: '🎮', slug: 'gaming-consoles' },
          { name: 'PC Gaming', description: 'Gaming PCs, graphics cards, peripherals', icon: '🖥️', slug: 'pc-gaming' },
          { name: 'Video Games', description: 'Game titles, digital downloads', icon: '🕹️', slug: 'video-games' },
          { name: 'Gaming Accessories', description: 'Controllers, headsets, chairs', icon: '🎧', slug: 'gaming-accessories' },
          { name: 'Retro Gaming', description: 'Classic consoles, vintage games', icon: '👾', slug: 'retro-gaming' },
          { name: 'Gaming Merchandise', description: 'Collectibles, apparel, figures', icon: '🏆', slug: 'gaming-merchandise' }
        ]
      },
      {
        name: 'Books / Education',
        description: 'Books, educational materials, and learning resources',
        icon: '📚',
        slug: 'books-education',
        isActive: true,
        sortOrder: 9,
        subcategories: [
          { name: 'Fiction Books', description: 'Novels, short stories, literature', icon: '📖', slug: 'fiction-books' },
          { name: 'Non-Fiction', description: 'Biographies, history, science', icon: '📝', slug: 'non-fiction' },
          { name: 'Educational Books', description: 'Textbooks, study guides, references', icon: '📚', slug: 'educational-books' },
          { name: 'Children\'s Books', description: 'Picture books, early readers', icon: '🧸', slug: 'childrens-books' },
          { name: 'E-Books', description: 'Digital books, audiobooks', icon: '📱', slug: 'e-books' },
          { name: 'Stationery', description: 'Notebooks, pens, office supplies', icon: '✏️', slug: 'stationery' }
        ]
      },
      {
        name: 'Music',
        description: 'Musical instruments, audio equipment, and music',
        icon: '🎵',
        slug: 'music',
        isActive: true,
        sortOrder: 10,
        subcategories: [
          { name: 'Musical Instruments', description: 'Guitars, keyboards, drums', icon: '🎸', slug: 'musical-instruments' },
          { name: 'Audio Equipment', description: 'Speakers, headphones, amplifiers', icon: '🎧', slug: 'audio-equipment' },
          { name: 'Music Production', description: 'Recording equipment, software', icon: '🎙️', slug: 'music-production' },
          { name: 'Vinyl & CDs', description: 'Physical music media', icon: '💿', slug: 'vinyl-cds' },
          { name: 'Sheet Music', description: 'Music books, songbooks', icon: '🎼', slug: 'sheet-music' },
          { name: 'Music Accessories', description: 'Cables, stands, cases', icon: '🎤', slug: 'music-accessories' }
        ]
      },
      {
        name: 'Food',
        description: 'Food products, snacks, and culinary items',
        icon: '🍔',
        slug: 'food',
        isActive: true,
        sortOrder: 11,
        subcategories: [
          { name: 'Fresh Food', description: 'Fruits, vegetables, meat, dairy', icon: '🥦', slug: 'fresh-food' },
          { name: 'Packaged Foods', description: 'Canned goods, snacks, cereals', icon: '🥫', slug: 'packaged-foods' },
          { name: 'International Cuisine', description: 'Ethnic foods, specialty ingredients', icon: '🌮', slug: 'international-cuisine' },
          { name: 'Organic & Health', description: 'Organic foods, health supplements', icon: '🌱', slug: 'organic-health' },
          { name: 'Frozen Foods', description: 'Frozen meals, ice cream', icon: '🧊', slug: 'frozen-foods' },
          { name: 'Cooking Ingredients', description: 'Spices, oils, baking supplies', icon: '🧂', slug: 'cooking-ingredients' }
        ]
      },
      {
        name: 'Coffee / Beverages',
        description: 'Coffee, tea, drinks, and beverage accessories',
        icon: '☕',
        slug: 'coffee-beverages',
        isActive: true,
        sortOrder: 12,
        subcategories: [
          { name: 'Coffee', description: 'Coffee beans, ground coffee, instant', icon: '☕', slug: 'coffee' },
          { name: 'Tea', description: 'Tea bags, loose leaf, herbal teas', icon: '🍵', slug: 'tea' },
          { name: 'Coffee Equipment', description: 'Coffee makers, grinders, accessories', icon: '⚡', slug: 'coffee-equipment' },
          { name: 'Soft Drinks', description: 'Soda, juice, energy drinks', icon: '🥤', slug: 'soft-drinks' },
          { name: 'Alcoholic Beverages', description: 'Wine, beer, spirits', icon: '🍷', slug: 'alcoholic-beverages' },
          { name: 'Water', description: 'Bottled water, flavored water', icon: '💧', slug: 'water' }
        ]
      },
      {
        name: 'Beauty & Personal Care',
        description: 'Cosmetics, skincare, personal hygiene and beauty products',
        icon: '💄',
        slug: 'beauty-personal-care',
        isActive: true,
        sortOrder: 13,
        subcategories: [
          { name: 'Skincare', description: 'Cleansers, moisturizers, serums, and treatments', icon: '🧴', slug: 'skincare' },
          { name: 'Makeup', description: 'Foundation, lipstick, eyeshadow, and cosmetics', icon: '💄', slug: 'makeup' },
          { name: 'Hair Care', description: 'Shampoo, conditioner, styling products', icon: '🧴', slug: 'hair-care' },
          { name: 'Fragrances', description: 'Perfumes, colognes, and body sprays', icon: '🌸', slug: 'fragrances' },
          { name: 'Personal Hygiene', description: 'Toothpaste, deodorant, body wash', icon: '🧼', slug: 'personal-hygiene' },
          { name: 'Nail Care', description: 'Nail polish, tools, and treatments', icon: '💅', slug: 'nail-care' },
          { name: 'Men\'s Grooming', description: 'Shaving, beard care, men\'s skincare', icon: '🪒', slug: 'mens-grooming' },
          { name: 'Beauty Tools', description: 'Brushes, mirrors, and beauty accessories', icon: '🪞', slug: 'beauty-tools' }
        ]
      },
      {
        name: 'Health & Wellness',
        description: 'Medical supplies, supplements, fitness and wellness products',
        icon: '🏥',
        slug: 'health-wellness',
        isActive: true,
        sortOrder: 14,
        subcategories: [
          { name: 'Vitamins & Supplements', description: 'Daily vitamins, protein, and health supplements', icon: '💊', slug: 'vitamins-supplements' },
          { name: 'Medical Supplies', description: 'First aid, thermometers, medical devices', icon: '🩹', slug: 'medical-supplies' },
          { name: 'Fitness Equipment', description: 'Weights, yoga mats, exercise gear', icon: '🏋️', slug: 'fitness-equipment' },
          { name: 'Health Monitoring', description: 'Blood pressure monitors, scales, fitness trackers', icon: '📊', slug: 'health-monitoring' },
          { name: 'Personal Care', description: 'Mobility aids, comfort products', icon: '🦽', slug: 'personal-care-health' },
          { name: 'Mental Wellness', description: 'Stress relief, meditation accessories', icon: '🧘', slug: 'mental-wellness' },
          { name: 'Sexual Health', description: 'Adult wellness and health products', icon: '💗', slug: 'sexual-health' },
          { name: 'Alternative Medicine', description: 'Herbal remedies, natural treatments', icon: '🌿', slug: 'alternative-medicine' }
        ]
      },
      {
        name: 'Toys & Kids',
        description: 'Toys, games, baby care, and children\'s products',
        icon: '🧸',
        slug: 'toys-kids',
        isActive: true,
        sortOrder: 15,
        subcategories: [
          { name: 'Baby Care', description: 'Diapers, formula, baby hygiene products', icon: '🍼', slug: 'baby-care' },
          { name: 'Educational Toys', description: 'Learning games, puzzles, STEM toys', icon: '📚', slug: 'educational-toys' },
          { name: 'Action Figures', description: 'Superhero figures, collectibles', icon: '🦸', slug: 'action-figures' },
          { name: 'Dolls & Plushies', description: 'Stuffed animals, dolls, soft toys', icon: '🧸', slug: 'dolls-plushies' },
          { name: 'Building Blocks', description: 'LEGO, construction sets, building toys', icon: '🧱', slug: 'building-blocks' },
          { name: 'Board Games', description: 'Family games, strategy games, card games', icon: '🎲', slug: 'board-games' },
          { name: 'Remote Control', description: 'RC cars, drones, electronic toys', icon: '🚁', slug: 'remote-control' },
          { name: 'Outdoor Play', description: 'Bikes, scooters, playground equipment', icon: '🛴', slug: 'outdoor-play' },
          { name: 'Arts & Crafts', description: 'Drawing supplies, craft kits for kids', icon: '🎨', slug: 'kids-arts-crafts' },
          { name: 'Baby Gear', description: 'Strollers, car seats, high chairs', icon: '👶', slug: 'baby-gear' }
        ]
      },
      {
        name: 'Sports & Outdoors',
        description: 'Athletic equipment, outdoor gear, and recreational products',
        icon: '🏀',
        slug: 'sports-outdoors',
        isActive: true,
        sortOrder: 16,
        subcategories: [
          { name: 'Team Sports', description: 'Football, basketball, soccer equipment', icon: '⚽', slug: 'team-sports' },
          { name: 'Individual Sports', description: 'Tennis, golf, swimming gear', icon: '🎾', slug: 'individual-sports' },
          { name: 'Outdoor Recreation', description: 'Camping, hiking, outdoor activities', icon: '🏕️', slug: 'outdoor-recreation' },
          { name: 'Water Sports', description: 'Swimming, surfing, water activities', icon: '🏄', slug: 'water-sports' },
          { name: 'Winter Sports', description: 'Skiing, snowboarding, ice skating', icon: '⛷️', slug: 'winter-sports' },
          { name: 'Fitness & Training', description: 'Gym equipment, workout gear', icon: '💪', slug: 'fitness-training' },
          { name: 'Cycling', description: 'Bikes, helmets, cycling accessories', icon: '🚴', slug: 'cycling' },
          { name: 'Running', description: 'Running shoes, gear, accessories', icon: '🏃', slug: 'running' },
          { name: 'Hunting & Fishing', description: 'Fishing gear, hunting equipment', icon: '🎣', slug: 'hunting-fishing' },
          { name: 'Outdoor Clothing', description: 'Athletic wear, outdoor apparel', icon: '🧥', slug: 'outdoor-clothing' }
        ]
      },
      {
        name: 'Automotive',
        description: 'Car parts, accessories, and automotive maintenance products',
        icon: '🚗',
        slug: 'automotive',
        isActive: true,
        sortOrder: 17,
        subcategories: [
          { name: 'Car Parts', description: 'Engine parts, brakes, filters', icon: '🔧', slug: 'car-parts' },
          { name: 'Car Accessories', description: 'Seat covers, phone mounts, organizers', icon: '🚗', slug: 'car-accessories' },
          { name: 'Car Care', description: 'Cleaning supplies, wax, detailing products', icon: '🧽', slug: 'car-care' },
          { name: 'Tires & Wheels', description: 'Tires, rims, wheel accessories', icon: '🛞', slug: 'tires-wheels' },
          { name: 'Electronics', description: 'Car stereos, GPS, dash cams', icon: '📻', slug: 'automotive-electronics' },
          { name: 'Tools', description: 'Automotive tools, diagnostic equipment', icon: '🔨', slug: 'automotive-tools' },
          { name: 'Oil & Fluids', description: 'Motor oil, brake fluid, coolant', icon: '🛢️', slug: 'oil-fluids' },
          { name: 'Motorcycle', description: 'Motorcycle parts and accessories', icon: '🏍️', slug: 'motorcycle' }
        ]
      },
      {
        name: 'Jewelry & Accessories',
        description: 'Fine jewelry, fashion accessories, and luxury items',
        icon: '💍',
        slug: 'jewelry-accessories',
        isActive: true,
        sortOrder: 18,
        subcategories: [
          { name: 'Fine Jewelry', description: 'Gold, silver, diamond jewelry', icon: '💎', slug: 'fine-jewelry' },
          { name: 'Fashion Jewelry', description: 'Costume jewelry, trendy accessories', icon: '💍', slug: 'fashion-jewelry' },
          { name: 'Watches', description: 'Luxury watches, smartwatches, timepieces', icon: '⌚', slug: 'watches' },
          { name: 'Handbags', description: 'Purses, clutches, designer bags', icon: '👜', slug: 'handbags' },
          { name: 'Sunglasses', description: 'Designer sunglasses, eyewear', icon: '🕶️', slug: 'sunglasses' },
          { name: 'Wallets', description: 'Leather wallets, card holders', icon: '👛', slug: 'wallets' },
          { name: 'Belts', description: 'Leather belts, fashion belts', icon: '👖', slug: 'belts' },
          { name: 'Hair Accessories', description: 'Hair clips, bands, styling accessories', icon: '🎀', slug: 'hair-accessories' }
        ]
      },
      {
        name: 'Pet Supplies',
        description: 'Pet food, toys, grooming, and care products',
        icon: '🐶',
        slug: 'pet-supplies',
        isActive: true,
        sortOrder: 19,
        subcategories: [
          { name: 'Dog Supplies', description: 'Dog food, toys, leashes, beds', icon: '🐕', slug: 'dog-supplies' },
          { name: 'Cat Supplies', description: 'Cat food, litter, toys, scratching posts', icon: '🐱', slug: 'cat-supplies' },
          { name: 'Bird Supplies', description: 'Bird food, cages, perches', icon: '🐦', slug: 'bird-supplies' },
          { name: 'Fish & Aquarium', description: 'Fish food, tanks, aquarium accessories', icon: '🐠', slug: 'fish-aquarium' },
          { name: 'Small Pets', description: 'Hamster, rabbit, guinea pig supplies', icon: '🐹', slug: 'small-pets' },
          { name: 'Pet Grooming', description: 'Brushes, shampoo, grooming tools', icon: '✂️', slug: 'pet-grooming' },
          { name: 'Pet Health', description: 'Vitamins, medications, first aid', icon: '🏥', slug: 'pet-health' },
          { name: 'Pet Travel', description: 'Carriers, travel bowls, car harnesses', icon: '🧳', slug: 'pet-travel' }
        ]
      },
      {
        name: 'Furniture',
        description: 'Home and office furniture for every room',
        icon: '🛋️',
        slug: 'furniture',
        isActive: true,
        sortOrder: 20,
        subcategories: [
          { name: 'Living Room', description: 'Sofas, coffee tables, entertainment centers', icon: '🛋️', slug: 'living-room-furniture' },
          { name: 'Bedroom', description: 'Beds, dressers, nightstands', icon: '🛏️', slug: 'bedroom-furniture' },
          { name: 'Dining Room', description: 'Dining tables, chairs, buffets', icon: '🪑', slug: 'dining-room-furniture' },
          { name: 'Kitchen', description: 'Kitchen islands, bar stools, cabinets', icon: '🍽️', slug: 'kitchen-furniture' },
          { name: 'Office', description: 'Desks, office chairs, filing cabinets', icon: '🏢', slug: 'office-furniture' },
          { name: 'Outdoor', description: 'Patio furniture, garden benches', icon: '🏡', slug: 'outdoor-furniture' },
          { name: 'Storage', description: 'Bookcases, storage ottomans, shelving', icon: '📚', slug: 'storage-furniture' },
          { name: 'Kids Furniture', description: 'Kids beds, toy storage, study desks', icon: '🧸', slug: 'kids-furniture' }
        ]
      },
      {
        name: 'Appliances',
        description: 'Home appliances for kitchen, laundry, and household use',
        icon: '🧊',
        slug: 'appliances',
        isActive: true,
        sortOrder: 21,
        subcategories: [
          { name: 'Kitchen Appliances', description: 'Refrigerators, ovens, dishwashers', icon: '🍳', slug: 'kitchen-appliances' },
          { name: 'Laundry', description: 'Washing machines, dryers, laundry accessories', icon: '🧺', slug: 'laundry-appliances' },
          { name: 'Small Appliances', description: 'Blenders, toasters, coffee makers', icon: '☕', slug: 'small-appliances' },
          { name: 'Heating & Cooling', description: 'Air conditioners, heaters, fans', icon: '❄️', slug: 'heating-cooling' },
          { name: 'Cleaning', description: 'Vacuum cleaners, steam cleaners', icon: '🧹', slug: 'cleaning-appliances' },
          { name: 'Water & Air', description: 'Water filters, air purifiers, humidifiers', icon: '💧', slug: 'water-air-appliances' },
          { name: 'Personal Care', description: 'Hair dryers, electric shavers, massagers', icon: '💆', slug: 'personal-care-appliances' }
        ]
      },
      {
        name: 'Groceries',
        description: 'Food, beverages, and everyday household essentials',
        icon: '🛒',
        slug: 'groceries',
        isActive: true,
        sortOrder: 22,
        subcategories: [
          { name: 'Fresh Produce', description: 'Fruits, vegetables, herbs', icon: '🥦', slug: 'fresh-produce' },
          { name: 'Dairy & Eggs', description: 'Milk, cheese, yogurt, eggs', icon: '🥛', slug: 'dairy-eggs' },
          { name: 'Meat & Seafood', description: 'Fresh meat, poultry, fish', icon: '🥩', slug: 'meat-seafood' },
          { name: 'Pantry Staples', description: 'Rice, pasta, canned goods', icon: '🍝', slug: 'pantry-staples' },
          { name: 'Snacks', description: 'Chips, crackers, candy', icon: '🍿', slug: 'snacks' },
          { name: 'Beverages', description: 'Juice, soda, water, energy drinks', icon: '🥤', slug: 'beverages' },
          { name: 'Frozen Foods', description: 'Frozen meals, ice cream, frozen vegetables', icon: '🧊', slug: 'frozen-foods' },
          { name: 'Bakery', description: 'Bread, pastries, cakes', icon: '🍞', slug: 'bakery' },
          { name: 'International Foods', description: 'Ethnic and specialty foods', icon: '🌮', slug: 'international-foods' },
          { name: 'Household Essentials', description: 'Paper towels, cleaning supplies, toiletries', icon: '🧻', slug: 'household-essentials' }
        ]
      },
      {
        name: 'Office Supplies',
        description: 'Stationery, office equipment, and business essentials',
        icon: '🖇️',
        slug: 'office-supplies',
        isActive: true,
        sortOrder: 23,
        subcategories: [
          { name: 'Writing Supplies', description: 'Pens, pencils, markers, highlighters', icon: '✏️', slug: 'writing-supplies' },
          { name: 'Paper Products', description: 'Notebooks, printer paper, sticky notes', icon: '📄', slug: 'paper-products' },
          { name: 'Organization', description: 'Binders, folders, filing systems', icon: '🗂️', slug: 'organization' },
          { name: 'Office Electronics', description: 'Printers, scanners, calculators', icon: '🖨️', slug: 'office-electronics' },
          { name: 'Desk Accessories', description: 'Desk organizers, paperweights, pen holders', icon: '📐', slug: 'desk-accessories' },
          { name: 'Presentation', description: 'Whiteboards, projectors, presentation supplies', icon: '📊', slug: 'presentation' },
          { name: 'Shipping & Mailing', description: 'Envelopes, packaging, labels', icon: '📦', slug: 'shipping-mailing' },
          { name: 'Break Room', description: 'Coffee supplies, snacks, kitchenware', icon: '☕', slug: 'break-room' }
        ]
      },
      {
        name: 'Travel & Luggage',
        description: 'Travel gear, luggage, and travel accessories',
        icon: '🧳',
        slug: 'travel-luggage',
        isActive: true,
        sortOrder: 24,
        subcategories: [
          { name: 'Luggage Sets', description: 'Suitcase sets, carry-on bags', icon: '🧳', slug: 'luggage-sets' },
          { name: 'Backpacks', description: 'Travel backpacks, hiking packs', icon: '🎒', slug: 'travel-backpacks' },
          { name: 'Travel Accessories', description: 'Travel pillows, adapters, organizers', icon: '✈️', slug: 'travel-accessories' },
          { name: 'Travel Electronics', description: 'Portable chargers, travel routers', icon: '🔌', slug: 'travel-electronics' },
          { name: 'Travel Comfort', description: 'Neck pillows, eye masks, compression socks', icon: '😴', slug: 'travel-comfort' },
          { name: 'Security', description: 'Luggage locks, RFID wallets, money belts', icon: '🔒', slug: 'travel-security' },
          { name: 'Outdoor Gear', description: 'Camping gear, hiking equipment', icon: '⛺', slug: 'outdoor-travel-gear' },
          { name: 'Business Travel', description: 'Laptop bags, garment bags, briefcases', icon: '💼', slug: 'business-travel' }
        ]
      },
      {
        name: 'Art & Crafts',
        description: 'Art supplies, craft materials, and DIY project essentials',
        icon: '🎨',
        slug: 'art-crafts',
        isActive: true,
        sortOrder: 25,
        subcategories: [
          { name: 'Drawing & Painting', description: 'Paints, brushes, canvases, drawing supplies', icon: '🖌️', slug: 'drawing-painting' },
          { name: 'Crafting Supplies', description: 'Glue, scissors, craft paper, decorations', icon: '✂️', slug: 'crafting-supplies' },
          { name: 'Sewing & Fabric', description: 'Fabric, thread, sewing machines, patterns', icon: '🧵', slug: 'sewing-fabric' },
          { name: 'Jewelry Making', description: 'Beads, wire, jewelry tools, findings', icon: '📿', slug: 'jewelry-making' },
          { name: 'Scrapbooking', description: 'Photo albums, decorative paper, stickers', icon: '📸', slug: 'scrapbooking' },
          { name: 'Knitting & Crochet', description: 'Yarn, knitting needles, crochet hooks', icon: '🧶', slug: 'knitting-crochet' },
          { name: 'Woodworking', description: 'Wood, tools, finishing supplies', icon: '🪵', slug: 'woodworking' },
          { name: 'Pottery & Clay', description: 'Clay, pottery tools, glazes', icon: '🏺', slug: 'pottery-clay' }
        ]
      },
      {
        name: 'Seasonal & Gifts',
        description: 'Holiday decorations, seasonal items, and gift products',
        icon: '🎁',
        slug: 'seasonal-gifts',
        isActive: true,
        sortOrder: 26,
        subcategories: [
          { name: 'Christmas', description: 'Christmas decorations, trees, ornaments', icon: '🎄', slug: 'christmas' },
          { name: 'Halloween', description: 'Costumes, decorations, candy', icon: '🎃', slug: 'halloween' },
          { name: 'Easter', description: 'Easter decorations, baskets, egg supplies', icon: '🐰', slug: 'easter' },
          { name: 'Valentine\'s Day', description: 'Romantic gifts, cards, decorations', icon: '💝', slug: 'valentines-day' },
          { name: 'Birthday', description: 'Party supplies, balloons, birthday gifts', icon: '🎂', slug: 'birthday' },
          { name: 'Wedding', description: 'Wedding decorations, favors, gifts', icon: '💒', slug: 'wedding' },
          { name: 'Summer', description: 'Pool accessories, BBQ supplies, outdoor fun', icon: '☀️', slug: 'summer' },
          { name: 'Back to School', description: 'School supplies, backpacks, lunch boxes', icon: '🎒', slug: 'back-to-school' },
          { name: 'Gift Cards', description: 'Digital and physical gift cards', icon: '💳', slug: 'gift-cards' },
          { name: 'Gift Wrapping', description: 'Wrapping paper, ribbons, gift bags', icon: '🎀', slug: 'gift-wrapping' }
        ]
      },
      {
        name: 'Featured / Favorites',
        description: 'Highlighted products and customer favorites',
        icon: '🌟',
        slug: 'featured-favorites',
        isActive: true,
        sortOrder: 27,
        subcategories: [
          { name: 'Best Sellers', description: 'Top-selling products across all categories', icon: '🏆', slug: 'best-sellers' },
          { name: 'New Arrivals', description: 'Latest products and releases', icon: '✨', slug: 'new-arrivals' },
          { name: 'Editor\'s Choice', description: 'Staff picks and recommendations', icon: '👑', slug: 'editors-choice' },
          { name: 'Customer Favorites', description: 'Highly rated by customers', icon: '❤️', slug: 'customer-favorites' },
          { name: 'Trending Now', description: 'Currently popular items', icon: '🔥', slug: 'trending-now' },
          { name: 'Limited Edition', description: 'Exclusive and limited-time offers', icon: '💎', slug: 'limited-edition' }
        ]
      },
      {
        name: 'Ideas / Innovation',
        description: 'Creative solutions, innovative products, and inspiration',
        icon: '💡',
        slug: 'ideas-innovation',
        isActive: true,
        sortOrder: 28,
        subcategories: [
          { name: 'Smart Home', description: 'IoT devices, home automation', icon: '🏠', slug: 'smart-home' },
          { name: 'Innovative Gadgets', description: 'Cutting-edge technology and tools', icon: '🔧', slug: 'innovative-gadgets' },
          { name: 'DIY Projects', description: 'Do-it-yourself kits and supplies', icon: '🛠️', slug: 'diy-projects' },
          { name: 'Creative Solutions', description: 'Problem-solving products', icon: '🧩', slug: 'creative-solutions' },
          { name: 'Eco-Friendly', description: 'Sustainable and green products', icon: '🌱', slug: 'eco-friendly' },
          { name: 'Future Tech', description: 'Emerging technologies and concepts', icon: '🚀', slug: 'future-tech' }
        ]
      },
      {
        name: 'Productivity / Goals',
        description: 'Tools and resources for productivity and goal achievement',
        icon: '🎯',
        slug: 'productivity-goals',
        isActive: true,
        sortOrder: 29,
        subcategories: [
          { name: 'Planning Tools', description: 'Planners, calendars, scheduling apps', icon: '📅', slug: 'planning-tools' },
          { name: 'Time Management', description: 'Tools for efficient time use', icon: '⏰', slug: 'time-management' },
          { name: 'Goal Setting', description: 'Resources for setting and tracking goals', icon: '🎯', slug: 'goal-setting' },
          { name: 'Productivity Apps', description: 'Software for enhanced productivity', icon: '📱', slug: 'productivity-apps' },
          { name: 'Organization Systems', description: 'Methods and tools for staying organized', icon: '🗂️', slug: 'organization-systems' },
          { name: 'Motivation & Inspiration', description: 'Resources for staying motivated', icon: '💪', slug: 'motivation-inspiration' }
        ]
      },
      {
        name: 'Tools / Maintenance',
        description: 'Tools, equipment, and maintenance supplies',
        icon: '🔧',
        slug: 'tools-maintenance',
        isActive: true,
        sortOrder: 30,
        subcategories: [
          { name: 'Hand Tools', description: 'Hammers, screwdrivers, wrenches', icon: '🔨', slug: 'hand-tools' },
          { name: 'Power Tools', description: 'Drills, saws, sanders', icon: '⚡', slug: 'power-tools' },
          { name: 'Tool Storage', description: 'Toolboxes, organizers, workbenches', icon: '🧰', slug: 'tool-storage' },
          { name: 'Maintenance Supplies', description: 'Lubricants, cleaners, replacement parts', icon: '🧽', slug: 'maintenance-supplies' },
          { name: 'Safety Equipment', description: 'Protective gear, safety tools', icon: '🦺', slug: 'safety-equipment' },
          { name: 'Measuring Tools', description: 'Rulers, levels, measuring devices', icon: '📏', slug: 'measuring-tools' }
        ]
      },
      {
        name: 'Finance / Subscriptions',
        description: 'Financial services, subscriptions, and digital products',
        icon: '💳',
        slug: 'finance-subscriptions',
        isActive: true,
        sortOrder: 31,
        subcategories: [
          { name: 'Digital Subscriptions', description: 'Streaming, software, online services', icon: '📺', slug: 'digital-subscriptions' },
          { name: 'Financial Services', description: 'Banking, investment, insurance', icon: '🏦', slug: 'financial-services' },
          { name: 'Gift Cards', description: 'Store credit, digital gift cards', icon: '🎁', slug: 'gift-cards-finance' },
          { name: 'Cryptocurrency', description: 'Digital currency, blockchain services', icon: '₿', slug: 'cryptocurrency' },
          { name: 'Payment Solutions', description: 'Digital wallets, payment apps', icon: '💰', slug: 'payment-solutions' },
          { name: 'Memberships', description: 'Club memberships, loyalty programs', icon: '🎫', slug: 'memberships' }
        ]
      }
    ];

    missingCategories.forEach((cat) => {
      let existingCategory = categories.findOne({ slug: cat.slug });
      
      if (!existingCategory) {
        // Add new category
        existingCategory = categories.insert({
          name: cat.name,
          description: cat.description,
          icon: cat.icon,
          slug: cat.slug,
          isActive: cat.isActive,
          sortOrder: cat.sortOrder,
        });
        console.log(`➕ Added category: ${cat.name}`);
      } else {
        console.log(`✅ Category exists: ${cat.name}`);
      }

      // Always check and add missing subcategories
      cat.subcategories.forEach((sub) => {
        const existingSubcategory = subcategories.findOne({ 
          slug: sub.slug, 
          categoryId: existingCategory.$loki 
        });
        
        if (!existingSubcategory) {
          subcategories.insert({
            name: sub.name,
            description: sub.description,
            icon: sub.icon,
            slug: sub.slug,
            categoryId: existingCategory.$loki,
            isActive: true,
            sortOrder: 0,
            createdAt: new Date().toISOString(),
            updatedAt: new Date().toISOString(),
            id: `SUBCAT-${Date.now()}-${Math.random().toString(36).substr(2, 9).toUpperCase()}`
          });
          console.log(`  ➕ Added subcategory: ${sub.name}`);
        }
      });
    });

    db.saveDatabase(() => {
      console.log("✅ Missing categories and subcategories added successfully.");
    });
  },
});