# Next.js Login App

A modern Next.js application with App Router featuring a styled login form built with Tailwind CSS.

## Features

- 🚀 **Next.js 15** with App Router
- 🎨 **Tailwind CSS v4** for styling
- 🔒 **Login Form** with validation
- 💨 **TypeScript** for type safety
- ✨ **Modern UI** with responsive design
- 🎯 **Form validation** and error handling
- 🔄 **Loading states** and user feedback

## Project Structure

```
src/
├── app/
│   ├── layout.tsx          # Root layout
│   ├── page.tsx            # Homepage
│   ├── login/
│   │   └── page.tsx        # Login page
│   └── globals.css         # Global styles with Tailwind
└── components/
    └── LoginForm.tsx       # Reusable login form component
```

## Getting Started

1. **Install dependencies:**
```bash
npm install
```

2. **Run the development server:**
```bash
npm run dev
```

3. **Open your browser:**
Navigate to [http://localhost:3000](http://localhost:3000) to see the homepage.

4. **Access the login form:**
Visit [http://localhost:3000/login](http://localhost:3000/login) to see the login form.

## Login Form Features

- **Email validation**: Checks for proper email format
- **Password validation**: Minimum 6 characters required
- **Loading states**: Shows spinner during form submission
- **Error handling**: Displays validation and submission errors
- **Responsive design**: Works on mobile and desktop
- **Accessibility**: Proper labels and focus management

## Available Scripts

- `npm run dev` - Start development server with Turbopack
- `npm run build` - Build for production with Turbopack
- `npm run start` - Start production server
- `npm run lint` - Run ESLint

## Technologies Used

- **Next.js 15** - React framework with App Router
- **React 19** - UI library
- **TypeScript** - Type safety
- **Tailwind CSS v4** - Utility-first CSS framework
- **ESLint** - Code linting
